if (UT2004_CONFIGURED)
    return()
endif()
set(UT2004_CONFIGURED TRUE)

SET(BUILD_SHARED_LIBS TRUE)
SET(CMAKE_LIBRARY_OUTPUT_DIRECTORY "../System")
SET(CMAKE_CXX_STANDARD 20)

SET(DO_CHECK ON CACHE BOOL "")
SET(DO_GUARD ON CACHE BOOL "")
SET(DO_CLOCK ON CACHE BOOL "")
SET(DO_STAT  ON CACHE BOOL "")

SET(DO_CHECK_SLOW OFF CACHE BOOL "")
SET(DO_GUARD_SLOW OFF CACHE BOOL "")
SET(DO_CLOCK_SLOW OFF CACHE BOOL "")
SET(DO_STAT_SLOW  OFF CACHE BOOL "")

SET(USE_PCH ON CACHE BOOL "")

add_compile_definitions(DO_CHECK=$<BOOL:${DO_CHECK}>)
add_compile_definitions(DO_GUARD=$<BOOL:${DO_GUARD}>)
add_compile_definitions(DO_CLOCK=$<BOOL:${DO_CLOCK}>)
add_compile_definitions(DO_STAT=$<BOOL:${DO_STAT}>)
add_compile_definitions(DO_CHECK_SLOW=$<BOOL:${DO_CHECK_SLOW}>)
add_compile_definitions(DO_GUARD_SLOW=$<BOOL:${DO_GUARD_SLOW}>)
add_compile_definitions(DO_CLOCK_SLOW=$<BOOL:${DO_CLOCK_SLOW}>)
add_compile_definitions(DO_STAT_SLOW=$<BOOL:${DO_STAT_SLOW}>)

add_compile_definitions(UNICODE=1 _UNICODE=1)

add_compile_definitions(WITH_KARMA=1)

if (MSVC)
    add_compile_options(/permissive-) # force conformance with C++ standard
    add_compile_options(/MP) # parallel compilation
    add_compile_options($<$<CONFIG:Release>:/GL>) # enable LTO
    add_link_options($<$<CONFIG:Release>:/LTCG>)  # enable LTO
    add_link_options(/STACK:67108864) # 64MB of stack size for GC (fuck linked lists)
endif()

set_property(GLOBAL PROPERTY USE_FOLDERS ON)

if (WIN32)
    add_compile_definitions(WIN32 _WIN32 _WINDOWS)
    add_compile_definitions(_CRT_SECURE_NO_DEPRECATE)
endif()

define_property(TARGET
    PROPERTY UNREAL_PACKAGE
    BRIEF_DOCS "Is this target an Unreal package"
    FULL_DOCS "Is this target an Unreal package"
)

define_property(TARGET
    PROPERTY UNREAL_NATIVE_PACKAGE
    BRIEF_DOCS "Is this target a native Unreal package"
    FULL_DOCS "Is this target a native Unreal package"
)

define_property(TARGET
    PROPERTY UNREAL_PACKAGE_DEPENDENCIES
    BRIEF_DOCS "Other packages this package depends on"
    FULL_DOCS "Other packages this package depends on"
)

function(GENERATE_MAKE_INI MakeIni)
    if (EXISTS MakeIni)
        file(REMOVE ${MakeIni})
    endif()

    file(WRITE  ${MakeIni} "; Generated, DO NOT MODIFY\n")
    file(APPEND ${MakeIni} "\n")
    file(APPEND ${MakeIni} "[Engine.Engine]\n")
    file(APPEND ${MakeIni} "EditorEngine=Editor.EditorEngine\n")
    file(APPEND ${MakeIni} "\n")
    file(APPEND ${MakeIni} "[Editor.EditorEngine]\n")
    file(APPEND ${MakeIni} "CacheSizeMegs=32\n")

    foreach(PKG ${ARGN})
        file(APPEND ${MakeIni} "EditPackages=${PKG}\n")
    endforeach()

    file(APPEND ${MakeIni} "\n")
    file(APPEND ${MakeIni} "[Core.System]\n")
    file(APPEND ${MakeIni} "CacheRecordPath=../System/*.ucl\n")
    file(APPEND ${MakeIni} "Paths=../System/*.u\n")
    file(APPEND ${MakeIni} "Paths=../Maps/*.ut2\n")
    file(APPEND ${MakeIni} "Paths=../Textures/*.utx\n")
    file(APPEND ${MakeIni} "Paths=../Sounds/*.uax\n")
    file(APPEND ${MakeIni} "Paths=../Music/*.umx\n")
    file(APPEND ${MakeIni} "Paths=../StaticMeshes/*.usx\n")
    file(APPEND ${MakeIni} "Paths=../Animations/*.ukx\n")
    file(APPEND ${MakeIni} "Paths=../Saves/*.uvx\n")
endfunction()

macro(_UNREAL_EXPAND_DEPENDENCIES_INNER L)
    foreach(Dep ${ARGN})
        get_target_property(IsPkg ${Dep} UNREAL_PACKAGE)
        if (NOT IsPkg)
            continue()
        endif()

        get_target_property(PkgDeps ${Dep} UNREAL_PACKAGE_DEPENDENCIES)
        _UNREAL_EXPAND_DEPENDENCIES_INNER(${L} ${PkgDeps})
        list(APPEND ${L} ${Dep})
    endforeach()
endmacro()

function(UNREAL_EXPAND_DEPENDENCIES Var)
    _UNREAL_EXPAND_DEPENDENCIES_INNER(${Var} ${ARGN} )
    list(REMOVE_DUPLICATES ${Var})
    set(${Var} ${${Var}} PARENT_SCOPE)
endfunction()

function(ADD_UNREAL_EXECUTABLE Target)
    add_executable(${Target} ${ARGN})
endfunction()

# ADD_UNREAL_PACKAGE(
#     <Target>
#     [CLASSES <Classes...>]
#     [DEPENDS_ON <Dependencies...>]
# )
function(ADD_UNREAL_PACKAGE Target)
    string(TOUPPER ${Target} TargetUp)
    cmake_parse_arguments(PARSE_ARGV 1 "AUP" "" "" "CLASSES;DEPENDS_ON")

    set(${TargetUp}_MAKE_INI "${CMAKE_CURRENT_BINARY_DIR}/make.ini" CACHE INTERNAL "Path to make.ini for package ${Target}")

    foreach(Dep ${AUP_DEPENDS_ON})
        if (NOT TARGET Dep)
            continue()
        endif()

        get_target_property(IsPkg ${Dep} UNREAL_PACKAGE)
        if (NOT IsPkg)
            continue()
        endif()

        list(APPEND PkgDep ${Dep})
    endforeach()

    unreal_expand_dependencies(FullPkgDeps ${PkgDep})
    
    generate_make_ini(${${TargetUp}_MAKE_INI} ${FullPkgDeps} ${Target})

    if(EXISTS "Classes/${Target}.upkg")
        set(${TargetUp}_UPKG_FILE "Classes/${Target}.upkg")
    else()
        set(${TargetUp}_UPKG_FILE "")
    endif()

    add_custom_target(
        ${Target}
        SOURCES ${AUP_CLASSES} ${${TargetUp}_UPKG_FILE}
    )
    set_target_properties(${Target} PROPERTIES
        UNREAL_PACKAGE              YES
        UNREAL_NATIVE_PACKAGE       NO
        UNREAL_PACKAGE_DEPENDENCIES ${PkgDep}
        FOLDER ${Target}
    )
    add_dependencies(${Target} ${AUP_DEPENDS_ON})
endfunction()

# ADD_UNREAL_NATIVE_PACKAGE(
#     <Target>
#     [NO_HEADER]
#     [CLASSES <Classes...>]
#     [SOURCES <Sources...>]
#     [DEPENDS_ON <Dependencies...>]
# )
function(ADD_UNREAL_NATIVE_PACKAGE Target)
    string(TOUPPER ${Target} TargetUp)
    cmake_parse_arguments(PARSE_ARGV 1 "AUNP" "NO_HEADER" "" "CLASSES;SOURCES;DEPENDS_ON")

    set(${TargetUp}_MAKE_INI "${CMAKE_CURRENT_BINARY_DIR}/make.ini" CACHE INTERNAL "Path to make.ini for package ${Target}")

    foreach(Dep ${AUNP_DEPENDS_ON})
        if (TARGET ${Dep})
            get_target_property(IsPkg ${Dep} UNREAL_PACKAGE)
            if (IsPkg)
                list(APPEND UnPkgDep ${Dep})
                if (TARGET ${Dep}Lib)
                    list(APPEND NativeDeps ${Dep}Lib)
                endif()

                continue()
            endif()
        endif()

        list(APPEND NativeDeps ${Dep})
    endforeach()

    if (DEFINED UnPkgDep AND UnPkgDep)
        unreal_expand_dependencies(FullPkgDeps ${UnPkgDep})
        generate_make_ini(${${TargetUp}_MAKE_INI} ${FullPkgDeps} ${Target})
    else()
        generate_make_ini(${${TargetUp}_MAKE_INI} ${Target})
    endif()

    ## native library for Unreal package

    if(AUNP_NO_HEADER)
        add_library(${Target}Lib
            ${AUNP_SOURCES}
        )
    else()
        add_library(${Target}Lib
            "${CMAKE_CURRENT_SOURCE_DIR}/Inc/${Target}Classes.h"
            ${AUNP_SOURCES}
        )
    endif()
    set_target_properties(${Target}Lib PROPERTIES
        OUTPUT_NAME ${Target}
        FOLDER ${Target}
    )
    target_compile_definitions(${Target}Lib PRIVATE "GPackage=GPackage${Target}" "ThisPackage=${Target}")
    target_include_directories(${Target}Lib PUBLIC ${CMAKE_CURRENT_SOURCE_DIR}/Inc)
    target_link_libraries(${Target}Lib ${NativeDeps})
    if (USE_PCH)
        if (EXISTS "Inc/${Target}Private.h")
            target_precompile_headers(${Target}Lib PRIVATE "Inc/${Target}Private.h")
        endif()
    endif()

    if (WIN32)
        target_compile_definitions(${Target}Lib PRIVATE "${TargetUp}_API=__declspec(dllexport)")
    endif()

    unreal_common_configure(${Target}Lib)

    ## actual Unreal package

    if(EXISTS "Classes/${Target}.upkg")
        set(${TargetUp}_UPKG_FILE "Classes/${Target}.upkg")
    else()
        set(${TargetUp}_UPKG_FILE "")
    endif()

    add_custom_target(
        ${Target}
        SOURCES ${AUNP_CLASSES} ${${TargetUp}_UPKG_FILE}
    )
    set_target_properties(${Target} PROPERTIES
        UNREAL_PACKAGE              YES
        UNREAL_NATIVE_PACKAGE       YES
        UNREAL_PACKAGE_DEPENDENCIES "${UnPkgDep}"
        FOLDER ${Target}
    )
endfunction()

function(UNREAL_COMMON_CONFIGURE Target)
    target_include_directories(${Target} PUBLIC ${CMAKE_CURRENT_SOURCE_DIR}/Inc)

    set_target_properties(${Target} PROPERTIES
        ARCHIVE_OUTPUT_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}/$<CONFIG>
        COMPILE_PDB_OUTPUT_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}/$<CONFIG>
        PDB_OUTPUT_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}/../System
    )

    set_target_properties(${Target} PROPERTIES
        RUNTIME_OUTPUT_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}/../System
        RUNTIME_OUTPUT_DIRECTORY_DEBUG ${CMAKE_CURRENT_SOURCE_DIR}/../System
        RUNTIME_OUTPUT_DIRECTORY_MINSIZEREL ${CMAKE_CURRENT_SOURCE_DIR}/../System
        RUNTIME_OUTPUT_DIRECTORY_RELWITHDEBINFO ${CMAKE_CURRENT_SOURCE_DIR}/../System
        RUNTIME_OUTPUT_DIRECTORY_RELEASE ${CMAKE_CURRENT_SOURCE_DIR}/../System
    )

    if (WIN32)
        set_target_properties(${Target} PROPERTIES
            LIBRARY_OUTPUT_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}/$<CONFIG>
        )
    else()
        set_target_properties(${Target} PROPERTIES
            LIBRARY_OUTPUT_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}/../System
            LIBRARY_OUTPUT_DIRECTORY_DEBUG ${CMAKE_CURRENT_SOURCE_DIR}/../System
            LIBRARY_OUTPUT_DIRECTORY_MINSIZEREL ${CMAKE_CURRENT_SOURCE_DIR}/../System
            LIBRARY_OUTPUT_DIRECTORY_RELWITHDEBINFO ${CMAKE_CURRENT_SOURCE_DIR}/../System
            LIBRARY_OUTPUT_DIRECTORY_RELEASE ${CMAKE_CURRENT_SOURCE_DIR}/../System
        )
    endif()
endfunction()

function(UNREAL_PACKAGE_CONFIGURE Target PackageName)
    if (NOT DEFINED PackageName)
        set(PackageName ${Target})
    endif()
    string(TOUPPER ${PackageName} PackageNameUp)

    target_compile_definitions(${Target} PRIVATE "GPackage=GPackage${PackageName}" "ThisPackage=${PackageName}")
    if (WIN32)
        target_compile_definitions(${Target} PRIVATE "${PackageNameUp}_API=__declspec(dllexport)")
    endif()

    if (USE_PCH)
        if (EXISTS "Inc/${Target}Private.h")
            target_precompile_headers(${Target} PRIVATE "Inc/${Target}Private.h")
        endif()
    endif()

    unreal_common_configure(${Target})
endfunction()

function(UNREAL_EXECUTABLE_CONFIGURE Target)
    unreal_common_configure(${Target})
endfunction()
